/*
 * Decompiled with CFR 0.152.
 */
package dev.lambdaurora.spruceui.option;

import dev.lambdaurora.spruceui.Position;
import dev.lambdaurora.spruceui.option.SpruceOption;
import dev.lambdaurora.spruceui.tooltip.TooltipData;
import dev.lambdaurora.spruceui.widget.SpruceButtonWidget;
import dev.lambdaurora.spruceui.widget.SpruceWidget;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.class_2561;
import org.jetbrains.annotations.NotNull;

public class SpruceCyclingOption
extends SpruceOption {
    private final Consumer<Integer> setter;
    private final Function<SpruceCyclingOption, class_2561> messageProvider;

    public SpruceCyclingOption(String key, Consumer<Integer> setter, Function<SpruceCyclingOption, class_2561> messageProvider, @NotNull TooltipData tooltip) {
        super(key);
        this.setter = setter;
        this.messageProvider = messageProvider;
        this.setTooltip(tooltip);
    }

    public void cycle(int amount) {
        this.setter.accept(amount);
    }

    @Override
    public SpruceWidget createWidget(Position position, int width) {
        SpruceButtonWidget button = new SpruceButtonWidget(position, width, 20, this.getMessage(), btn -> {
            this.cycle(1);
            btn.setMessage(this.getMessage());
        });
        this.getTooltip().ifPresent(button::setTooltip);
        return button;
    }

    public class_2561 getMessage() {
        return this.messageProvider.apply(this);
    }

    public static class Builder
    extends SpruceOption.Builder<Builder, SpruceCyclingOption> {
        private final Consumer<Integer> setter;
        private final Function<SpruceCyclingOption, class_2561> messageProvider;

        public Builder(String key, Consumer<Integer> setter, Function<SpruceCyclingOption, class_2561> messageProvider) {
            super(key);
            this.setter = setter;
            this.messageProvider = messageProvider;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public SpruceCyclingOption build() {
            return new SpruceCyclingOption(this.key, this.setter, this.messageProvider, this.tooltip);
        }
    }
}

